// Bibliotheken einbinden
#include <FastLED.h>

// Anzahl der LED-Leuchten in Ihrem Streifen
#define NUM_LEDS 30

// Anschluss der LED-Streifen an Ihren Mikrocontroller
#define DATA_PIN 6

// Variable zur Speicherung der Farben Ihrer LEDs
CRGB leds[NUM_LEDS];

void setup() {
  // Initialisierung der seriellen Schnittstelle für die Kommunikation mit Ihrem Computer
  Serial.begin(9600);

  // Initialisierung des LED-Streifens
  FastLED.addLeds<WS2812B, DATA_PIN, GRB>(leds, NUM_LEDS);

  // Setzen Sie die Helligkeit Ihrer LEDs (0-255)
  FastLED.setBrightness(50);
}

void loop() {
  // Fortnite-Themenablauf
  // Standardfarben
  CRGB color_idle = CRGB::Black; // schwarz
  CRGB color_building = CRGB::Blue; // blau
  CRGB color_shooting = CRGB::Red; // rot
  CRGB color_victory = CRGB::Green; // grün
  
  // Abfrage des aktuellen Spielzustands
  bool is_building = false;
  bool is_shooting = false;
  bool is_victory = false;
  
  // Code zum Auslesen des Spielzustands hinzufügen

  // Setzen Sie die Farbe Ihrer LEDs entsprechend des Spielzustands
  if (is_victory) {
    victoryAnimation(color_victory);
  } else if (is_shooting) {
    shootingAnimation(color_shooting);
  } else if (is_building) {
    buildingAnimation(color_building);
  } else {
    idleAnimation(color_idle);
  }
}

// Animationen
void idleAnimation(CRGB color) {
  // LEDs blinken abwechselnd in der Farbe "color"
  for (int i = 0; i < NUM_LEDS; i++) {
    if (i % 2 == 0) {
      leds[i] = color;
    } else {
      leds[i] = CRGB::Black;
    }
  }
  FastLED.show();
  delay(500);
  for (int i = 0; i < NUM_LEDS; i++) {
    if (i % 2 == 0) {
      leds[i] = CRGB::Black;
    } else {
      leds[i] = color;
    }
  }
  FastLED.show();
  delay(500);
}

void buildingAnimation(CRGB color) {
  // Farbverlauf von "color" zu "CRGB::Black"
  for (int i = 0; i < NUM_LEDS; i++) {
    float t = (float)i / NUM_LEDS;
    CRGB interpolated_color = color.lerp8(CRGB::Black, t * t * t);
    leds[i] = interpolated_color;
  }
  FastLED.show();
  delay(50);
}

void shootingAnimation(CRGB color) {
  // LEDs blinken in "color"
  for (int i = 0; i < NUM_LEDS; i++) {
    leds[i] = color;
  }
  FastLED.show();
  delay(100);
  for (int i = 0; i < NUM_LEDS; i++) {
    leds[i] = CRGB::Black;
  }
  FastLED.show();
  delay(100);
}


void victoryAnimation(CRGB color) {
// Farbverlauf von "CRGB::Black" zu "color"
for (int i = 0; i < NUM_LEDS; i++) {
float t = (float)i / NUM_LEDS;
CRGB interpolated_color = CRGB::Black.lerp8(color, t * t);
leds[i] = interpolated_color;
}
FastLED.show();
delay(50);
}