#include <FastLED.h>

// define number of LEDs and data pin
#define NUM_LEDS 60
#define DATA_PIN 6

// create CRGB object for LED control
CRGB leds[NUM_LEDS];

// define LED colors for different Minecraft dimensions
CRGB overworldColor = CRGB(0, 255, 0); // green
CRGB netherColor = CRGB(255, 0, 0); // red
CRGB endColor = CRGB(128, 0, 128); // purple

void setup() {
  // initialize serial communication
  Serial.begin(9600);

  // initialize FastLED library
  FastLED.addLeds<WS2812B, DATA_PIN, GRB>(leds, NUM_LEDS);

  // set initial LED color to overworldColor
  for (int i = 0; i < NUM_LEDS; i++) {
    leds[i] = overworldColor;
  }

  // show LED colors
  FastLED.show();
}

void loop() {
  // detect Minecraft dimension (for example by reading player's coordinates)
  // if in overworld
  if (/* code to detect overworld */) {
    setLEDsColor(overworldColor);
  }
  // if in nether
  else if (/* code to detect nether */) {
    setLEDsColor(netherColor);
  }
  // if in end
  else if (/* code to detect end */) {
    setLEDsColor(endColor);
  }

  // wait for 50 milliseconds before checking again
  delay(50);
}

void setLEDsColor(CRGB color) {
  // set all LEDs to specified color
  for (int i = 0; i < NUM_LEDS; i++) {
    leds[i] = color;
  }

  // show LED colors
  FastLED.show();
}
