#include <FastLED.h>

// Define LED parameters
#define LED_PIN 6
#define NUM_LEDS 30
CRGB leds[NUM_LEDS];

// Define color variables
CRGB purple = CRGB(200, 0, 255);
CRGB blue = CRGB(0, 50, 255);
CRGB lightBlue = CRGB(0, 255, 255);
CRGB green = CRGB(0, 255, 0);
CRGB yellow = CRGB(255, 255, 0);
CRGB red = CRGB(255, 0, 0);
CRGB orange = CRGB(255, 100, 0);

void setup() {
  // Initialize LED strip
  FastLED.addLeds<WS2812B, LED_PIN, GRB>(leds, NUM_LEDS).setCorrection(TypicalLEDStrip);

  // Set brightness level
  FastLED.setBrightness(100);

  // Turn on all LEDs to blue
  fill_solid(leds, NUM_LEDS, blue);
  FastLED.show();
}

void loop() {
  // Check for Warden sound effects
  if (analogRead(A0) > 200) {
    // Flash LEDs
    fill_solid(leds, NUM_LEDS, white);
    FastLED.show();
    delay(50);
    fill_solid(leds, NUM_LEDS, black);
    FastLED.show();
    
    // Change LED color based on sound level
    int soundLevel = analogRead(A0) / 4;
    if (soundLevel < 20) {
      fill_solid(leds, NUM_LEDS, purple);
    }
    else if (soundLevel < 40) {
      fill_solid(leds, NUM_LEDS, blue);
    }
    else if (soundLevel < 60) {
      fill_solid(leds, NUM_LEDS, lightBlue);
    }
    else if (soundLevel < 80) {
      fill_solid(leds, NUM_LEDS, green);
    }
    else if (soundLevel < 100) {
      fill_solid(leds, NUM_LEDS, yellow);
    }
    else if (soundLevel < 120) {
      fill_solid(leds, NUM_LEDS, orange);
    }
    else {
      fill_solid(leds, NUM_LEDS, red);
    }
    FastLED.show();
  }
  // If no sound is detected, turn all LEDs to blue
  else {
    fill_solid(leds, NUM_LEDS, blue);
    FastLED.show();
  }
}
