#include <FastLED.h>

#define LED_PIN     2
#define NUM_LEDS    60

CRGB leds[NUM_LEDS];

void setup() {
  FastLED.addLeds<WS2812, LED_PIN, GRB>(leds, NUM_LEDS);
  FastLED.setBrightness(50);
}

void loop() {
  int volume = analogRead(A0);
  int brightness = map(volume, 0, 1023, 0, 255);
  FastLED.setBrightness(brightness);
  
  for (int i = 0; i < NUM_LEDS; i++) {
    int hue = map(i, 0, NUM_LEDS, 0, 255);
    leds[i] = CHSV(hue, 255, brightness);
  }
  
  FastLED.show();
  delay(20);
}
