#include <FastLED.h>

#define LED_PIN     6
#define NUM_LEDS    60
#define BRIGHTNESS  100
#define FRAMES_PER_SECOND 60

CRGBPalette16 palette = CRGBPalette16(
  CRGB::OrangeRed,
  CRGB::Yellow,
  CRGB::LightYellow,
  CRGB::SkyBlue,
  CRGB::DeepSkyBlue,
  CRGB::Purple
);

CRGB leds[NUM_LEDS];

void setup() {
  FastLED.addLeds<WS2812B, LED_PIN, GRB>(leds, NUM_LEDS);
  FastLED.setBrightness(BRIGHTNESS);
}

void loop() {
  static uint8_t startIndex = 0;
  startIndex = startIndex + 1;
  
  // fill the entire strip with the current palette
  for (int i = 0; i < NUM_LEDS; i++) {
    leds[i] = ColorFromPalette(palette, startIndex + (i * 2), 255, LINEARBLEND);
  }
  
  FastLED.show();
  FastLED.delay(1000 / FRAMES_PER_SECOND);
}
