#include <FastLED.h>

#define LED_PIN 6
#define NUM_LEDS 60
CRGB leds[NUM_LEDS];

unsigned long lastMovementTime = 0;
const unsigned long movementTimeout = 300000; // 5 Minuten in Millisekunden

void setup() {
  FastLED.addLeds<WS2812B, LED_PIN, GRB>(leds, NUM_LEDS);
  FastLED.setBrightness(100);
}

void loop() {
  // Bewegung abfragen und letzte Bewegungszeit aktualisieren
  if(detectMovement()) {
    lastMovementTime = millis();
  }
  
  // Prüfen, ob die Zeitüberschreitung erreicht wurde
  if(millis() - lastMovementTime > movementTimeout) {
    // LEDs ausschalten
    FastLED.clear();
    FastLED.show();
  } else {
    // LEDs einschalten
    int red = 255;
    int green = 255;
    int blue = 255;
    // Hier könnte man noch weitere Farben oder Farbverläufe einfügen, je nach Bedarf
    for(int i = 0; i < NUM_LEDS; i++) {
      leds[i] = CRGB(red, green, blue);
    }
    FastLED.show();
  }
  delay(10);
}

// Funktion, um die Bewegung des Spielers zu überprüfen
bool detectMovement() {
  // Hier müsste man die Bewegung des Spielers abfragen und entsprechend zurückgeben
  // Beispiel:
  return digitalRead(MOTION_SENSOR_PIN) == HIGH;
}
