#include <FastLED.h>

#define NUM_LEDS 30 // Anzahl der LEDs in deinem Streifen
#define DATA_PIN 6 // Der Pin, an dem dein LED-Streifen angeschlossen ist
CRGB leds[NUM_LEDS];

boolean enderdragonBesiegt = false; // Boolean Variable, die auf true gesetzt wird, wenn der Enderdrache besiegt wurde

void setup() {
  FastLED.addLeds<WS2812, DATA_PIN, GRB>(leds, NUM_LEDS); // Initialisiere den LED-Streifen
  FastLED.setBrightness(50); // Setze die Helligkeit der LEDs auf 50%
}

void loop() {
  if(enderdragonBesiegt) { // Wenn der Enderdrache besiegt wurde...
    fill_rainbow(leds, NUM_LEDS, 0); // Setze den Streifen in einen Farbverlauf
    FastLED.show(); // Aktualisiere den LED-Streifen
    delay(33000); // Warte 5 Minuten und 30 Sekunden (33.000 Millisekunden)
    enderdragonBesiegt = false; // Setze die Variable zurück
  }
}

void enderdracheBesiegt() {
  enderdragonBesiegt = true; // Setze die Variable auf true, wenn der Enderdrache besiegt wurde
}
