#include <FastLED.h>

#define LED_PIN     6
#define NUM_LEDS    60
#define MIC_PIN     A0

CRGB leds[NUM_LEDS];

void setup() {
  FastLED.addLeds<WS2812B, LED_PIN, GRB>(leds, NUM_LEDS);
  Serial.begin(9600);
}

void loop() {
  uint16_t volume = analogRead(MIC_PIN); // read the microphone sensor
  Serial.println(volume);
  if (volume > 50) { // if volume is above a threshold value
    for (int i = 0; i < NUM_LEDS; i++) {
      leds[i] = CRGB(volume, 0, 0); // set the color of the LEDs based on the volume
    }
    FastLED.show(); // show the updated LEDs
    delay(100); // delay to allow the LEDs to be seen
    fill_solid(leds, NUM_LEDS, CRGB::Black); // turn off the LEDs
    FastLED.show(); // show the updated LEDs
  }
}
