#include <FastLED.h>

#define LED_PIN 6
#define NUM_LEDS 60
CRGB leds[NUM_LEDS];

void setup() {
  FastLED.addLeds<WS2812B, LED_PIN, GRB>(leds, NUM_LEDS);
  FastLED.setBrightness(100);
}

void loop() {
  int red = 0;
  int green = 0;
  int blue = 0;
  
  // Spielzustand abfragen und entsprechend die Farben setzen
  // Beispiel:
  if(inStoryMode()) {
    red = 128; // Lila leuchten im Story-Modus
    blue = 128;
  } else if(inMainMenu()) {
    green = 128; // Grün leuchten im Hauptmenü
  } else {
    // Hier kann man weitere Bedingungen für andere Zustände ergänzen
    red = 255;
    green = 255;
    blue = 255;
  }
  
  // Farben auf LEDs setzen
  for(int i = 0; i < NUM_LEDS; i++) {
    leds[i] = CRGB(red, green, blue);
  }
  FastLED.show();
  delay(10);
}

// Funktionen, um den aktuellen Spielzustand zu überprüfen
bool inStoryMode() {
  // Hier müsste man den aktuellen Spielzustand abfragen und entsprechend zurückgeben
  // Beispiel:
  return true;
}

bool inMainMenu() {
  // Hier müsste man den aktuellen Spielzustand abfragen und entsprechend zurückgeben
  // Beispiel:
  return false;
}
