#include <FastLED.h>

#define LED_PIN 6
#define NUM_LEDS 60
CRGB leds[NUM_LEDS];

void setup() {
  FastLED.addLeds<WS2812B, LED_PIN, GRB>(leds, NUM_LEDS);
  FastLED.setBrightness(100);
}

void loop() {
  int red = 0;
  int green = 0;
  int blue = 0;
  
  // Spielzustand abfragen und entsprechend die Farben setzen
  // Beispiel:
  if(isPlaying()) {
    red = 255; // Rot leuchten beim Spielen
  } else {
    blue = 255; // Blau leuchten im Menü
  }
  
  // Farben auf LEDs setzen
  for(int i = 0; i < NUM_LEDS; i++) {
    leds[i] = CRGB(red, green, blue);
  }
  FastLED.show();
  delay(10);
}

// Funktion, um den aktuellen Spielzustand zu überprüfen
bool isPlaying() {
  // Hier müsste man den aktuellen Spielzustand abfragen und entsprechend zurückgeben
  // Beispiel:
  return true;
}
