#include <FastLED.h>

#define LED_PIN 6
#define NUM_LEDS 60
CRGB leds[NUM_LEDS];

void setup() {
  FastLED.addLeds<WS2812B, LED_PIN, GRB>(leds, NUM_LEDS);
  FastLED.setBrightness(100);
}

void loop() {
  // Farben für die verschiedenen Modi definieren
  CRGB background_color = CRGB::Black; // Hintergrundfarbe
  CRGB text_color = CRGB::White; // Textfarbe
  CRGB highlight_color = CRGB::Yellow; // Farbe für aktive Elemente

  // Abfrage, ob Visual Studio Code im Fokus ist
  bool vs_code_focused = isVSCodeFocused();
  
  // Wenn Visual Studio Code im Fokus ist, Farben setzen
  if (vs_code_focused) {
    // Hintergrundfarbe
    background_color = CRGB::Black;
    // Textfarbe
    text_color = CRGB::White;
    // Farbe für aktive Elemente
    highlight_color = CRGB::Blue;
  }

  // LEDs setzen
  setLEDs(background_color, text_color, highlight_color);

  delay(10);
}

// Funktion, um zu überprüfen, ob Visual Studio Code im Fokus ist
bool isVSCodeFocused() {
  // Hier müsste man die Methode implementieren, um den Fokus auf Visual Studio Code zu überprüfen
  // Beispiel:
  return (GetForegroundWindow() == FindWindow(NULL, "Visual Studio Code"));
}

// Funktion, um die LEDs zu setzen
void setLEDs(CRGB bg, CRGB txt, CRGB highlight) {
  // Hier könnte man die LEDs entsprechend des Visual Studio Code-Layouts anordnen
  // Beispiel:
  for(int i = 0; i < NUM_LEDS; i++) {
    if(i < 20) { // Erste Zeile
      leds[i] = bg;
    } else if (i >= 20 && i < 40) { // Zweite Zeile
      leds[i] = txt;
    } else { // Dritte Zeile
      leds[i] = highlight;
    }
  }
  FastLED.show();
}
